function [npoint]=bfgs(fun,point);

%constants
relprec=1e-3;
c1=0.01;
c2=0.8;

global do_plot_model

%first point and initialization
k=0;
n=length(point);
npoint=point;
figure(1);
[nval,ngrad]=feval(fun,npoint);
dist=1;
distbound=sqrt(n);
H=eye(n)/norm(ngrad);

%main loop
while (norm(ngrad)>relprec*n) 

  if (norm(point)>1/eps)
    disp(['bfgs seems to run off to infinity: norm(current_point)>1/eps)']);
    return;
  end

  if (dist<eps)
    disp(['bfgs seems to stall: norm(current-next)<eps)']);
    return;
  end

  if (k>100)
    disp(['bfgs iteration limit of 100 iterations reached']);
    return;
  end

  val=nval;
  grad=ngrad;

  if (n==2)&(do_plot_model==1)
    figure(2);clf;
    contourmodel(fun,point,val,grad,inv(H));
    contourmodel(fun,point,val,grad,inv(H));
    hold on;
  end
    if (n==2)&(k>0)&(do_plot_model==1)
    plot([oldpoint(1)],[oldpoint(2)],'go');
    h2=line([oldpoint(1);oldpoint(1)+.3*oldgrad(1)/norm(oldgrad)],[oldpoint(2);oldpoint(2)+.3*oldgrad(2)/norm(oldgrad)]);
    set(h2,'Color','g');
  end

  % compute step direction
  dir=-H*grad;
 
  if(n==2)&(do_plot_model==1)
    figure(2); 
    h1=line([point(1);point(1)+.3*dir(1)/norm(dir)],[point(2);point(2)+.3*dir(2)/norm(dir)]);
    set(h1,'Color','r');
    h2=line([point(1);point(1)+.3*grad(1)/norm(grad)],[point(2);point(2)+.3*grad(2)/norm(grad)]);
    set(h2,'Color','g');
  end



  % do the line search
    maxa=distbound/norm(dir);
figure(1);
  [npoint,nval,ngrad]=linesearch(fun,point,dir,maxa,val,grad,c1,c2)
  
  %store for plots
  oldpoint=point;
  oldgrad=grad;
  olddir=dir;

  % update the model
  s=npoint-point;
  y=ngrad-grad;
  yts=y'*s;
  if (k==0)
    H=eye(n)*(yts/(y'*y));
  end
  if (yts>1e-6)
    disp('update of H')
    Hy=H*y;
    u=(s*((1+(y'*Hy)/yts)/2)-Hy)/yts;
    H=H+u*s'+s*u';
  else
    disp('no update of H')
  end  

  % update the upper bound on the step size
  dist=norm(npoint-point);
  if (dist>.1*distbound)
    distbound=distbound*10
  elseif (dist<.01*distbound)
    distbound=distbound/10
  end
 
  point=npoint;
  k=k+1;  
end

