

function addTitleToEachDescendantOfClass(domElement, arrayOfIndices, arrayOfClassNames, countersStartWhere) {

    // console.log("addTitle... called with indices=" + arrayOfIndices + " and arrayOfClassNames=" + arrayOfClassNames);
    if (arrayOfClassNames.length == 0) {
        // end of recursion reached

        let titleSpan = domElement.querySelector(".numbered-title");
        if (!titleSpan) {
            titleSpan = document.createElement("span");
            titleSpan.innerHTML = "undefined environment; add &lt;span class='numbered-title'&gt;Übung&lt;/span&gt; or similar";
            titleSpan.classList.add("numbered-title");
            domElement.prepend(titleSpan);
        }


        // titleSpan.innerHTML += " ";

        let prefix = "";
        if (arrayOfIndices.length == 1) {
            prefix += "" + arrayOfIndices[0] + ". ";
        }
        else {
            for (let i = 0; i < arrayOfIndices.length - 1; i++) {
                prefix += "" + arrayOfIndices[i] + ".";
            }
            prefix += "" + arrayOfIndices[arrayOfIndices.length - 1];
        }
        titleSpan.innerHTML = prefix + " " + titleSpan.innerHTML;
        return;
    }

    Array.from(domElement.getElementsByClassName(arrayOfClassNames[0])).forEach(function (childElement, index) {
        arrayOfIndices.push(index + countersStartWhere[0]);
        addTitleToEachDescendantOfClass(childElement, arrayOfIndices, arrayOfClassNames.slice(1),
            countersStartWhere.slice(1));
        arrayOfIndices.pop();
    });
}



addTitleToEachDescendantOfClass(document, [],
    ["topic"],
    [1]);

addTitleToEachDescendantOfClass(document, [],
    ["topic", "subtopic"],
    [1, 1]);



