

/***
 * 
 * find the chapter and subchapter number of the given file
 * 
 */


[chapterNumber, subChapterNumber] = getIndices(getCurrentFilename(), tableOfContents);

numberingString = (subChapterNumber) ? `${chapterNumber}.${subChapterNumber}` : chapterNumber;

/* set the title to the correct chapter */

document.querySelector("title").textContent = `Proseminar, Kapitel ${numberingString}`;

subChapterTitleElement = document.querySelector(".subChapterTitle");
if (subChapterTitleElement) {
    let subChapter = getSubChapter([chapterNumber, subChapterNumber]);
    subChapterTitleElement.textContent = `${numberingString} ${subChapter.name}`;

}

chapterTitleElement = document.querySelector(".chapterTitle");
if (chapterTitleElement) {
    chapterTitleElement.textContent = `${numberingString}. ${tableOfContents[chapterNumber - 1].name}`;

}

/* creating the navigation links */

createHeaderLinks();


/* functions for getting indices, names, href of this, prev and next chapter */

function getIndicesOfNext() {
    let nextJ;
    if (subChapterNumber === undefined) {
        /* we are at the beginning of a chapter, in subchapter 0 so to speak */
        nextJ = 1;
    }
    else {
        nextJ = subChapterNumber + 1;
    }
    if (tableOfContents[chapterNumber - 1].subChapters[nextJ - 1]) {
        return [chapterNumber, nextJ];
    }
    let nextI = chapterNumber + 1;
    if (tableOfContents[nextI - 1]) {
        return [nextI];
    }
    return [];
}
function getIndicesOfPrev() {
    let prevJ = subChapterNumber - 1;
    if (prevJ === 0) {
        return [chapterNumber];
    }
    if (prevJ > 0) {
        return [chapterNumber, prevJ];
    }
    let prevI = chapterNumber - 1;
    if (prevI === 0) {
        return [];
    }
    // else we are in the last subchapter of the previous chapter
    prevJ = tableOfContents[prevI - 1].subChapters.length;
    if (prevJ === 0) {
        return [prevI]
    }
    else {
        return [prevI, prevJ];
    }

}

function indicesToString(indices) {
    if (indices.length === 1) {
        return `${indices[0]}`;
    }
    else {
        return `${indices[0]}.${indices[1]}`
    }
}



function createHeaderLinks() {
    let headerDiv = document.querySelector("#navigation-links");
    headerDiv.innerHTML = '';

    let linkToTocDiv = document.createElement("div");
    linkToTocDiv.id = "link-to-toc";
    headerDiv.appendChild(linkToTocDiv);

    let p = document.createElement("p");
    linkToTocDiv.appendChild(p);
    let a = document.createElement("a");
    p.appendChild(a);

    a.innerHTML = `Inhaltsverzeichnis`;
    a.href = `../vorlesungsskript.html`;

    /* now create link to previous chapter */
    let prevIndices = getIndicesOfPrev();
    if (prevIndices[0]) {

        p = document.createElement("p");
        linkToTocDiv.appendChild(p);

        a = document.createElement("a");
        p.appendChild(a);


        a.innerHTML = `<< Kapitel ${indicesToString(prevIndices)}`;
        a.href = getSubChapter(prevIndices).href;
    }

    let linkToOverviewDiv = document.createElement("div");
    linkToOverviewDiv.id = "link-to-overview";
    headerDiv.appendChild(linkToOverviewDiv);

    p = document.createElement("p");
    linkToOverviewDiv.appendChild(p);
    a = document.createElement("a");
    p.appendChild(a);

    a.innerHTML = `zur Kursübersicht`;
    a.href = `../index.html`;

    /* now create link to next chapter */

    let nextIndices = getIndicesOfNext();
    if (nextIndices[0]) {
        p = document.createElement("p");
        linkToOverviewDiv.appendChild(p);
        a = document.createElement("a");
        p.appendChild(a);


        a.innerHTML = `Kapitel ${indicesToString(nextIndices)} >>`;
        a.href = getSubChapter(nextIndices).href;
    }

}




function getCurrentFilename() {
    var url = window.location.pathname;
    var filename = url.substring(url.lastIndexOf('/') + 1);
    return filename;
}


function getSubChapter([i, j]) {
    if (j === undefined) {
        return tableOfContents[i - 1];
    }
    return tableOfContents[i - 1].subChapters[j - 1];
}



/*
    href : String 
    chapters : Array {name:String, href:String, subChapters : Array {name: String, href: String}}
*/

function getIndices(href, chapters) {
    for (i in chapters) {
        if (href === chapters[i].href) {
            return [parseInt(i) + 1];
        }
        let j = getIndexInSubChapters(href, chapters[i].subChapters);
        if (j) {
            return [parseInt(i) + 1, j];
        }
    }
    return undefined;
}


/* 
    href : String 
    subChapters : Array {name : String, href : String}

    returns: index of subchapter where href matches, undefined if none
*/

function getIndexInSubChapters(href, subChapters) {
    for (j in subChapters) {
        // console.log(`href here is ${subChapters[j].href}`);
        if (subChapters[j].href === href) {
            return parseInt(j) + 1;
        }
    }
    return undefined;
}




/**
 * 
 * number the environments exercise and theorem correctly
 * 
 * 
 */

let referenceTable = {};

/*** to be used later to get numbers of theorems and so on 
 * 
 * 
 * > referenceTable['theorem-equivalence']
 * '1.2'
 * */


/*
addTitleToEachDescendantOfClass(document, [],
    ["chapter", "subChapter", "numbered-exercise"],
    [chapterNumber, subChapterNumber, 1]);
addTitleToEachDescendantOfClass(document, [], ["chapter", "subChapter", "theorem"],
    [chapterNumber, subChapterNumber, 1]);
*/

let numberedExercises = document.querySelectorAll('.numbered-exercise .numbered-title');
let numberedTheorems = document.querySelectorAll('.theorem .numbered-title');

assignNumbersAndLabels("Theorem", numberedTheorems);
assignNumbersAndLabels("Exercise", numberedExercises);

function assignNumbersAndLabels(elementName, collection) {
    collection.forEach(function (e, index) {
        let indexString = `${numberingString}.${index + 1}`
        e.innerHTML += ' ' + indexString;
        if (e.hasAttribute('id')) {
            let label = e.getAttribute('id');
            console.log(`${elementName} ${indexString} has id ${label}`);
            referenceTable[label] = indexString;
        }
    });
}
createReferences();

function createReferences() {
    let references = document.querySelectorAll('.reference');
    references.forEach(function (e) {
        if (!e.hasAttribute('data-ref')) {
            return;
        }
        let ref = e.getAttribute('data-ref');
        console.log(`found reference to ${ref}`);
        let runningNumber = referenceTable[ref];
        console.log(`running number is  ${runningNumber}`);

        let aTag = document.createElement("a");
        aTag.href = `#${ref}`;
        aTag.textContent = `${runningNumber}`;
        e.appendChild(aTag);
    });
}





/*
function addTitleToEachDescendantOfClass(domElement, arrayOfIndices, arrayOfClassNames, countersStartWhere) {

    // console.log("addTitle... called with indices=" + arrayOfIndices + " and arrayOfClassNames=" + arrayOfClassNames);
    if (arrayOfClassNames.length == 0) {
        // end of recursion reached

        let titleSpan = domElement.querySelector(".numbered-title");
        if (!titleSpan) {
            titleSpan = document.createElement("span");
            titleSpan.innerHTML = "undefined environment; add &lt;span class='numbered-title'&gt;Exercise&lt;/span&gt; or similar";
            titleSpan.classList.add("numbered-title");
            domElement.prepend(titleSpan);
        }


        titleSpan.innerHTML += " ";
        if (arrayOfIndices.length == 1) {
            titleSpan.innerHTML += "" + arrayOfIndices[0] + ". ";
        }
        else {
            for (let i = 0; i < arrayOfIndices.length - 1; i++) {
                titleSpan.innerHTML += "" + arrayOfIndices[i] + ".";
            }
            titleSpan.innerHTML += "" + arrayOfIndices[arrayOfIndices.length - 1];
        }
        return;
    }

    Array.from(domElement.getElementsByClassName(arrayOfClassNames[0])).forEach(function (childElement, index) {
        arrayOfIndices.push(index + countersStartWhere[0]);
        addTitleToEachDescendantOfClass(childElement, arrayOfIndices, arrayOfClassNames.slice(1),
            countersStartWhere.slice(1));
        arrayOfIndices.pop();
    });
}

*/



