
/*
 input arg toc must be a list of 
 {name : String, subChapters : Array of String}

 returns an <ol>-Element
*/
function createTableOfContents(contentDirectory, toc) {
    let ol = document.createElement("ol");
    ol.className = "nested";
    for (let chapter of toc) {
        let chapterLi = document.createElement("li");
        ol.appendChild(chapterLi);
        chapterAnchor = document.createElement("a");
        chapterLi.appendChild(chapterAnchor);
        chapterAnchor.textContent = chapter.name;
        chapterAnchor.href = contentDirectory + "/" + chapter.href;
        let subChaptersOl = document.createElement("ol");
        subChaptersOl.className = "nested";
        chapterLi.appendChild(subChaptersOl);
        for (let subChapter of chapter.subChapters) {
            let subChapterLi = document.createElement("li");
            let subChapterAnchor = document.createElement("a");
            subChapterLi.appendChild(subChapterAnchor);
            subChapterAnchor.textContent = subChapter.name;
            subChapterAnchor.href = contentDirectory + "/" + subChapter.href;
            subChaptersOl.appendChild(subChapterLi);
        }
    }
    return ol;
}