import sys 

if (len(sys.argv) < 1):
    print("usage: python assignment-to-matching")
    sys.exit(-1)

line1 = input()
if (line1 == "UNSAT"):
    print(f"graph has no perfect matching")
    exit(0)

assignment_all = map(int, input().split())

assignment = [] 

for l in assignment_all:
    if l > 0:
        assignment.append(l)

n = 2 * len(assignment)

sys.stderr.write(str(assignment) + "\n")


power_of_ten = 1 
while (power_of_ten <= n):
    power_of_ten *= 10 


def decode_edge(index):
    u = index % power_of_ten 
    v = index // power_of_ten 
    return (u, v)


print("[")

output_strings = [] 
for l in assignment:
    if l > 0:
        (u,v) = decode_edge(l)
        output_strings.append(f"  {{\"start\": {u},\n   \"end\": {v}\n  }}")

print(',\n'.join(output_strings))

print("]")
