const express = require("express");
const path = require("path");
const cookieparser = require("cookie-parser");
const fs = require("fs");
const cors = require("cors");
const app = express();
const https = require("https");
const url = require("url");
const commander = require('commander');

// allow the app to use cookieparser
app.use(cookieparser());

// allow the express server to process POST request rendered by the ejs files 
app.use(express.json());
app.use(express.urlencoded({ extended: false }));

// allow the express server to read and render the static css file
app.use(express.static(path.join(__dirname, "..", "public")));
app.set("view engine", "ejs");
app.set("views", path.join(__dirname, "views"));

commander
  .version('1.0.0', '-v, --version')
  .usage('[OPTIONS]...')
  .option('--http-only <value>', `Sets cookies to be http-only (not appear in client's javascript environment) `, "false")
  .option('--same-site  <value>', 'Setting the same site policy (None, Lax, Strict), ', 'lax')
  .option('--https', 'making the server use https and set cookies to secure')
  .option('--port <value>', 'the port number', 4013)
  .option('--cors', 'allow cors requests')
  .option('--cors-credentials', 'allow cookies in cors requests')
  .parse(process.argv);

const options = commander.opts();
// console.log(`command line options: ${JSON.stringify(options)}`);
console.log(`command line options:`);
for (option in options) {
  console.log(`${option}:\t${options[option]}`);
}





/*** 
 * Cookie Options. This variable is used below when the server sets the cookies.
 * 
 * In this app, the cookie options are the same for every cookie setting operation.
 * 
 * ***/

const httpOnly = options["httpOnly"] === "true";
const sameSite = options["sameSite"];
const secure = options["https"] === true;
const PORT = parseInt(options["port"]) || 4013;
const allow_cors = options["cors"] === true;
const cors_credentials = options["corsCredentials"] === true;

if (allow_cors) {

  const cors_options = {
    origin: '*' //origin: ['http://localhost:8080', 'http://127.0.0.1:8080'], credentials: cors_credentials
  }
  console.log(`cors options: ${JSON.stringify(cors_options)}`);
  app.use(cors(cors_options));

}



const COOKIE_OPTIONS = {
  expires: new Date(2147483647000),
  httpOnly: httpOnly,
  sameSite: sameSite,
  secure: secure
};

console.log(`COOKIE_OPTIONS: ${JSON.stringify(COOKIE_OPTIONS)}`);



if (secure) {
  /* use https */
  httpServer = https.createServer(
    {
      key: fs.readFileSync("cert/selfsigned.key"),
      cert: fs.readFileSync("cert/selfsigned.crt"),
    },
    app
  )
    .listen(PORT, function () {
      console.log('listening at port ' + PORT);
    });
}
else {
  /* use http */
  app.listen(PORT, () => console.log(`server started on port: ${PORT}`));
}



let session_ids = {};
let emails = {};

messages =
  [
    { username: "King", content: "I'm the king" },
    { username: "Duke", content: "I'm the duke" }
  ];

// a port number to expose the server


app.get("/", (req, res) => {
  // check if user is logged in, by checking cookie
  let username = req.cookies.username;
  let session_id = req.cookies.session_id;
  if (username && session_id && session_ids[username] == session_id) {
    return res.redirect("/main");
  }
  // render the home page
  return res.render("home");
});



app.get("/register", (req, res) => {
  return res.render("register");
});


app.post("/process_create_new_account", (req, res) => {
  let { username, email, password } = req.body;
  console.log("attempt to create new account with data " + JSON.stringify(req.body));
  let passwords = JSON.parse(fs.readFileSync("./passwords.json", { encoding: 'utf8', flag: 'r' }));
  if (passwords[username] != undefined) {
    // return res.redirect("register-failed");
    return res.render("register", { error: "failed to register; username already taken" });
  }
  // else: creating the account was successful
  passwords[username] = password;
  emails[username] = email;
  fs.writeFileSync("./passwords.json", JSON.stringify(passwords));
  // return res.redirect("register-successful");
  return res.render("login", { success_message: "Your account has been created. Please log in!" });
});

app.get("/login", (req, res) => {
  return res.render("login");
});

app.post("/process_login", (req, res) => {

  // get the data
  let { username, password } = req.body;

  let passwords = JSON.parse(fs.readFileSync("./passwords.json", { encoding: 'utf8', flag: 'r' }));

  console.log("/process_login");
  console.log(`\tusername = ${username}`);
  console.log(`\tpassword = ${password}`);

  // basic check
  if (
    passwords[username] === password
  ) {
    // saving the data to the cookies



    let session_id = JSON.stringify(Math.random());

    res.cookie("username", username, COOKIE_OPTIONS);
    res.cookie("session_id", session_id, COOKIE_OPTIONS);
    session_ids[username] = session_id;
    console.log("login successful");
    console.log(`\tusername: ${username}`);
    console.log(`\tpassword: ${password}`);
    console.log(`\tsession_id: ${session_ids[username]}`);
    // Success! redirect
    return res.redirect("/main");
  } else {
    // Failure! 
    // return res.redirect("/login-failed");
    res.render("login", { error: "Invalid username or password" });
  }
});



app.get("/logout", (req, res) => {
  // clear the cookie
  console.log(`/logout requested with cookie ${JSON.stringify(req.cookies)}`);
  if (req.cookies.username) {
    delete session_ids[req.cookies.username];
  }
  res.clearCookie("session_id");
  res.clearCookie("username");

  // redirect to login
  return res.redirect("/login");
});


app.get("/main", (req, res) => {
  // get the username
  let username = req.cookies.username;

  console.log("/main requested");
  console.log("\tcookie: " + JSON.stringify(req.cookies));

  if (!username) {
    console.log(`got a request on /main but without username. Here is the cookie data: ${JSON.stringify(req.cookies)}`);
    return res.render("login", { error: "No username provided" });
  }

  console.log(`\tsession_ids[${username}]: ${session_ids[username]}`);

  if (!session_ids[username]) {
    return res.render("login", { error: `Sorry ${username}, you are not logged in.` });
  }

  if (session_ids[username] != req.cookies.session_id) {
    return res.render("login", { error: "Wrong session id" });
  }

  // render welcome page
  return res.render("main", {
    username: username, session_id: session_ids[username]
  });
});

function fib(n) {
  let a = 0;
  let b = 1;
  while (n > 0) {
    temp = a + b;
    a = b;
    b = temp;
    n--;
  }
  return a;
}

app.get("/fib", (req, res) => {

  const query = url.parse(req.url, true).query;
  console.log(`/fib requested with n=${query.n}`);
  let n = parseInt(query.n) || 0;

  return res.render('fib', { n: n, result: fib(n) });
});



const axios = require('axios');
app.get("/get-cities", async function (req, res) {

  const query = url.parse(req.url, true).query;
  let n = parseInt(query.n) || 0;
  let result = { result: fib(n) };

  const options = {
    method: 'GET',
    url: 'https://wft-geo-db.p.rapidapi.com/v1/geo/cities',
    headers: {
      'X-RapidAPI-Key': '3004920d14msh6d79ab4e117d68ep130870jsn456d0c3abdd6',
      'X-RapidAPI-Host': 'wft-geo-db.p.rapidapi.com'
    },
    params: { limit: 2, namePrefix: "Berli", offset: 30 }
  };

  try {
    const response = await axios.request(options);
    console.log(response.data);
    res.send(JSON.stringify(response.data));
  } catch (error) {
    console.log("http request to wft-geo-db has failed");
    return res.send("http request to wft-geo-db has failed");
  }
});


app.get("/fib-raw", function (req, res) {
  const query = url.parse(req.url, true).query;
  console.log(`/fib-raw requested with n=${query.n} and cookies ${JSON.stringify(req.cookies)}`);
  let n = parseInt(query.n) || 0;
  let result = { result: fib(n) };
  const responseString = JSON.stringify(result)
  console.log(`answering request to /fib-raw with string ${responseString}`);
  res.send(responseString);
});


app.get("/fib-text", function (req, res) {
  const query = url.parse(req.url, true).query;
  console.log(`/fib-raw requested with n=${query.n} and cookies ${JSON.stringify(req.cookies)}`);
  let n = parseInt(query.n) || 0;
  const responseString = '' + fib(n);
  console.log(`answering request to /fib-raw with string ${responseString}`);
  res.send(responseString);
});






app.get("/get-messages", (req, res) => {
  // get the username
  let username = req.cookies.username;

  console.log("/get-messages requested");
  console.log("\tcookie: " + JSON.stringify(req.cookies));

  if (!username) {
    console.log(`got a request on /get-messages but without username. Here is the cookie data: ${JSON.stringify(req.cookies)}`);
    return res.render("login", { error: "No username provided" });
  }

  console.log(`\tsession_ids[${username}]: ${session_ids[username]}`);

  if (!session_ids[username]) {
    return res.render("login", { error: `Sorry ${username}, you are not logged in.` });
  }

  if (session_ids[username] != req.cookies.session_id) {
    return res.render("login", { error: "Wrong session id" });
  }

  res.status(200);
  return res.send(JSON.stringify(messages));

});




app.post("/add-message", (req, res) => {
  let username = req.cookies.username;

  console.log("/add-message requested");
  console.log("\tcookie: " + JSON.stringify(req.cookies));
  console.log("\tbody: " + JSON.stringify(req.body));

  if (!username) {
    console.log(`got a request on /add-message but without username. Here is the cookie data: ${JSON.stringify(req.cookies)}`);
    messages.push({ username: "anonymous", content: req.body.content });
    return res.render("login", { error: "No username provided" });
  }

  console.log(`\tsession_ids[${username}]: ${session_ids[username]}`);

  if (!session_ids[username]) {
    return res.render("login", { error: `Sorry ${username}, you are not logged in.` });
  }

  if (session_ids[username] != req.cookies.session_id) {
    console.log(`user ${username} provided session_id=${req.cookies.session_id},
    but the correct one would have been ${session_ids[username]}`);
    return res.render("login", { error: "Wrong session id" });
  }
  // add the message
  messages.push({ username: username, content: req.body.content });
  // render welcome page
  return res.redirect("/main");
});


