// src/index.js

// import all the modules/packages
const express = require("express");
const path = require("path");
// const helmet = require("helmet");
const cookieparser = require("cookie-parser");
const fs = require("fs");
const cors = require("cors");
// allow the app to use express
const app = express();
const https = require('https');

const portnumber = 4023;

httpServer = https.createServer(
  {
    key: fs.readFileSync("cert/selfsigned.key"),
    cert: fs.readFileSync("cert/selfsigned.crt"),
  },
  app
)
  .listen(portnumber, function () {
    console.log('listening at port ' + portnumber);
  });


// allow the app to use cookieparser
app.use(cookieparser());

// allow the express server to process POST request rendered by the ejs files 
app.use(express.json());
app.use(express.urlencoded({ extended: false }));

// allow the express server to read and render the static css file
app.use(express.static(path.join(__dirname, "..", "public")));
app.set("view engine", "ejs");

app.use(cors({
  origin: ['http://localhost:8080', 'http://127.0.0.1:8080'], credentials: true
}));



// render the ejs views
app.set("views", path.join(__dirname, "views"));



let session_ids = {};
let emails = {};

messages =
  [
    { username: "King", content: "I'm the king" },
    { username: "Duke", content: "I'm the duke" }
  ];




app.get("/", (req, res) => {
  // check if user is logged in, by checking cookie
  let username = req.cookies.username;
  let session_id = req.cookies.session_id;
  if (username && session_id && session_ids[username] == session_id) {
    return res.redirect("/main");
  }
  // render the home page
  return res.render("home");
});



app.get("/register", (req, res) => {
  return res.render("register");
});


app.post("/process_create_new_account", (req, res) => {
  let { username, email, password } = req.body;
  console.log("attempt to create new account with data " + JSON.stringify(req.body));
  let passwords = JSON.parse(fs.readFileSync("./passwords.json", { encoding: 'utf8', flag: 'r' }));
  if (passwords[username] != undefined) {
    // return res.redirect("register-failed");
    return res.render("register", { error: "failed to register; username already taken" });
  }
  // else: creating the account was successful
  passwords[username] = password;
  emails[username] = email;
  fs.writeFileSync("./passwords.json", JSON.stringify(passwords));
  // return res.redirect("register-successful");
  return res.render("login", { success_message: "Your account has been created. Please log in!" });
});

app.get("/login", (req, res) => {
  return res.render("login");
});

app.post("/process_login", (req, res) => {

  // get the data
  let { username, password } = req.body;

  let passwords = JSON.parse(fs.readFileSync("./passwords.json", { encoding: 'utf8', flag: 'r' }));

  console.log("/process_login");
  console.log(`\tusername = ${username}`);
  console.log(`\tpassword = ${password}`);

  // basic check
  if (
    passwords[username] === password
  ) {
    // saving the data to the cookies



    let session_id = JSON.stringify(Math.random());
    // let COOKIE_OPTIONS = {};
    // let COOKIE_OPTIONS = { httpOnly: true};

    let COOKIE_OPTIONS = { sameSite: 'None', secure: true };
    res.cookie("username", username, COOKIE_OPTIONS);
    res.cookie("session_id", session_id, COOKIE_OPTIONS);


    session_ids[username] = session_id;
    console.log("login successful");
    console.log(`\tusername: ${username}`);
    console.log(`\tpassword: ${password}`);
    console.log(`\tsession_id: ${session_ids[username]}`);
    // Success! redirect
    return res.redirect("/main");
  } else {
    // Failure! 
    // return res.redirect("/login-failed");
    res.render("login", { error: "Invalid username or password" });
  }
});



app.get("/logout", (req, res) => {
  // clear the cookie
  console.log(`/logout requested with cookie ${JSON.stringify(req.cookies)}`);
  if (req.cookies.username) {
    delete session_ids[req.cookies.username];
  }
  res.clearCookie("session_id");
  res.clearCookie("username");

  // redirect to login
  return res.redirect("/login");
});


app.get("/main", (req, res) => {
  // get the username
  let username = req.cookies.username;

  console.log("/main requested");
  console.log("\tcookie: " + JSON.stringify(req.cookies));

  if (!username) {
    console.log(`got a request on /main but without username. Here is the cookie data: ${JSON.stringify(req.cookies)}`);
    return res.render("login", { error: "No username provided" });
  }

  console.log(`\tsession_ids[${username}]: ${session_ids[username]}`);

  if (!session_ids[username]) {
    return res.render("login", { error: `Sorry ${username}, you are not logged in.` });
  }

  if (session_ids[username] != req.cookies.session_id) {
    return res.render("login", { error: "Wrong session id" });
  }

  // render welcome page
  return res.render("main", {
    username: username, session_id: session_ids[username]
  });
});



app.get("/get-messages", (req, res) => {
  // get the username
  let username = req.cookies.username;

  console.log("/get-messages requested");
  console.log("\tcookie: " + JSON.stringify(req.cookies));

  if (!username) {
    console.log(`got a request on /get-messages but without username. Here is the cookie data: ${JSON.stringify(req.cookies)}`);
    return res.render("login", { error: "No username provided" });
  }

  console.log(`\tsession_ids[${username}]: ${session_ids[username]}`);

  if (!session_ids[username]) {
    return res.render("login", { error: `Sorry ${username}, you are not logged in.` });
  }

  if (session_ids[username] != req.cookies.session_id) {
    return res.render("login", { error: "Wrong session id" });
  }

  res.status(200);
  return res.send(JSON.stringify(messages));

});



app.post("/add-message", (req, res) => {
  let username = req.cookies.username;

  console.log("/add-message requested");
  console.log("\tcookie: " + JSON.stringify(req.cookies));
  console.log("\tbody: " + JSON.stringify(req.body));

  if (!username) {
    console.log(`got a request on /add-message but without username. Here is the cookie data: ${JSON.stringify(req.cookies)}`);
    return res.render("login", { error: "No username provided" });
  }

  console.log(`\tsession_ids[${username}]: ${session_ids[username]}`);

  if (!session_ids[username]) {
    return res.render("login", { error: `Sorry ${username}, you are not logged in.` });
  }

  if (session_ids[username] != req.cookies.session_id) {
    console.log(`user ${username} provided session_id=${req.cookies.session_id},
    but the correct one would have been ${session_ids[username]}`);
    return res.render("login", { error: "Wrong session id" });
  }
  // add the message
  messages.push({ username: username, content: req.body.content });
  // render welcome page
  return res.redirect("/main");
});




