// src/server.js

// import all the modules/packages
const express = require("express");
const path = require("path");
const cookieparser = require("cookie-parser");

// allow the app to use express
const app = express();

// allow the app to use cookieparser
app.use(cookieparser());

// allow the express server to process POST request rendered by the ejs files 
app.use(express.json());
app.use(express.urlencoded({ extended: false }));

// allow the express server to read and render the static css file
app.use(express.static(path.join(__dirname, "..", "public")));
app.set("view engine", "ejs");

// render the ejs views
app.set("views", path.join(__dirname, "views"));

messages =
  [
    { username: "King", content: "I'm the king" },
    { username: "Duke", content: "I'm the duke" }
  ];

// a port number to expose the server
const PORT = process.env.PORT || 4012;

app.get("/", (req, res) => {
  return res.render("home");
});

app.get("/login", (req, res) => {
  return res.render("login");
});

app.get("/register", (req, res) => {
  return res.render("register");
});

app.get("/register-successful", (req, res) => {
  return res.render("login", { success_message: "Your account has been created. Please log in!" });
});

app.post("/add-message", (req, res) => {
  messages.push({ username: req.body.username, content: req.body.content });
  return res.redirect("/main");
});

app.get("/main", (req, res) => {
  return res.render("main", {
    username: ""
  });
});

app.post("/process_login", (req, res) => {
  let { username, password } = req.body;

  console.log("/process_login");
  console.log(`\tusername = ${username}`);
  console.log(`\tpassword = ${password}`);

  return res.redirect("/main");
});

app.post("/process_create_new_account", (req, res) => {
  let { username, email, password } = req.body;
  console.log("attempt to create new account with data " + JSON.stringify(req.body));  
  return res.redirect("register-successful");
});

app.get("/logout", (req, res) => {  
  return res.redirect("/login");
});

app.listen(PORT, () => console.log(`server started on port: ${PORT}`));