import java.util.Vector;
import java.util.Hashtable;
import java.util.Scanner;

public class Graph extends Digraph {

    public Graph(int n) {
        super(n);
    }

    public void addEdge(String uName, String vName) {
        super.addEdge(uName, vName);
        super.addEdge(vName, uName);
    }


    public static Graph read(Scanner scanner) {
        Log.print("number of vertices: ");
        int n = scanner.nextInt();
        Log.print("number of edges: ");
        int m = scanner.nextInt();

        Graph graph = new Graph(n);

        for (int i = 0; i < n; i++) {
            Log.print("name of vertex " + i + ": ");
            String name = scanner.next();
            Log.println("I read vertex \"" + name + "\"");
            graph.addVertex(name);
        }


        for (int i = 0; i < m; i++) {
            Log.print("enter edge " + (i+1) + " out of " + m + ": ");
            String uName = scanner.next();
            String vName = scanner.next();
            Log.println("I read edge (" + uName + ", " + vName + ").");
            graph.addEdge(uName, vName);
        }
        return graph;
    }

}