Xenomai : Nucleus ;

Nucleus : C_X_OPT_PERVASIVE
	| C_X_OPT_PIPELINE_HEAD
	| C_X_OPT_SCHED_CLASSES
	| C_X_OPT_STATS
	| C_X_OPT_DEBUG
	| C_X_OPT_SHIRQ
	| Timing
	| Scalability
	| Machine
	| Interfaces
	| Drivers ;

C_X_OPT_PERVASIVE : C_X_OPT_PRIOCPL ;

C_X_OPT_SCHED_CLASSES : C_X_OPT_SCHED_TP
	| C_X_OPT_SCHED_SPORADIC ;

C_X_OPT_DEBUG : C_X_OPT_DEBUG_NUCLEUS
	| C_X_OPT_DEBUG_XNLOCK
	| C_X_OPT_DEBUG_QUEUES
	| C_X_OPT_DEBUG_REGISTRY
	| C_X_OPT_DEBUG_TIMERS
	| C_X_OPT_DEBUG_SYNCH_RELAX
	| C_X_OPT_DEBUG_WATCHDOG ;

Timing : C_X_OPT_TIMING_PERIODIC ;

Scalability : C_X_OPT_SCALABLE_SCHED
	| TimerIndexingMethod ;

TimerIndexingMethod : C_X_OPT_TIMER_LIST
	| C_X_OPT_TIMER_HEAP
	| C_X_OPT_TIMER_WHEEL ;

Machine : C_X_HW_FPU
	| NMIWatchdog
	| SMIWorkaround ;

NMIWatchdog : C_X_HW_NMI_DEBUG_LATENCY ;

SMIWorkaround : C_X_HW_SMI_DETECT_DISABLE ;

C_X_HW_SMI_DETECT_DISABLE : C_X_HW_SMI_WORKAROUND ;

C_X_HW_SMI_WORKAROUND : C_X_HW_SMI_ALL ;

C_X_HW_SMI_ALL : C_X_HW_SMI_INTEL_USB2
	| C_X_HW_SMI_LEGACY_USB2
	| C_X_HW_SMI_PERIODIC
	| C_X_HW_SMI_TCO
	| C_X_HW_SMI_MC
	| C_X_HW_SMI_APMC
	| C_X_HW_SMI_LEGACY_USB
	| C_X_HW_SMI_BIOS ;

Interfaces : C_X_SKIN_NATIVE
	| C_X_SKIN_POSIX
	| C_X_SKIN_PSOS
	| C_X_SKIN_UITRON
	| C_X_SKIN_VRTX
	| C_X_SKIN_VXWORKS
	| C_X_SKIN_RTAI
	| C_X_OPT_NOWARN_DEPRECATED
	| C_X_SKIN_RTDM ;

C_X_SKIN_NATIVE : C_X_OPT_NATIVE_PIPE
	| C_X_OPT_NATIVE_SEM
	| C_X_OPT_NATIVE_EVENT
	| C_X_OPT_NATIVE_MUTEX
	| C_X_OPT_NATIVE_COND
	| C_X_OPT_NATIVE_QUEUE
	| C_X_OPT_NATIVE_BUFFER
	| C_X_OPT_NATIVE_HEAP
	| C_X_OPT_NATIVE_ALARM
	| C_X_OPT_NATIVE_MPS
	| C_X_OPT_NATIVE_INTR ;

C_X_SKIN_POSIX : C_X_OPT_POSIX_SHM
	| C_X_OPT_POSIX_INTR
	| C_X_OPT_POSIX_SELECT
	| C_X_OPT_DEBUG_POSIX ;

C_X_SKIN_RTAI : C_X_OPT_RTAI_FIFO
	| C_X_OPT_RTAI_SEM
	| C_X_OPT_RTAI_SHM ;

C_X_SKIN_RTDM : C_X_OPT_RTDM_SELECT ;

Drivers : SerialDrivers
	| TestingDrivers
	| C_X_DRIVERS_CAN
	| C_X_DRIVERS_ANALOGY
	| C_X_DRIVERS_RTIPC ;

SerialDrivers : C_X_DRIVERS_16550A ;

C_X_DRIVERS_16550A : C_X_DRIVERS_16550A_PIO
	| C_X_DRIVERS_16550A_MMIO
	| C_X_DRIVERS_16550A_ANY ;

TestingDrivers : C_X_DRIVERS_TIMERBENCH
	| C_X_DRIVERS_IRQBENCH
	| C_X_DRIVERS_SWITCHTEST
	| C_X_DRIVERS_SIGTEST ;

C_X_DRIVERS_TIMERBENCH : C_X_DRIVERS_KLATENCY ;

C_X_DRIVERS_CAN : C_X_DRIVERS_CAN_DEBUG
	| C_X_DRIVERS_CAN_LOOPBACK
	| C_X_DRIVERS_CAN_VIRT
	| C_X_DRIVERS_CAN_SJA1000 ;

C_X_DRIVERS_CAN_SJA1000 : C_X_DRIVERS_CAN_SJA1000_ISA
	| C_X_DRIVERS_CAN_SJA1000_MEM
	| C_X_DRIVERS_CAN_SJA1000_PEAK_PCI
	| C_X_DRIVERS_CAN_SJA1000_IXXAT_PCI
	| C_X_DRIVERS_CAN_SJA1000_EMS_PCI
	| C_X_DRIVERS_CAN_SJA1000_ESD_PCI
	| C_X_DRIVERS_CAN_SJA1000_PEAK_DNG ;

C_X_DRIVERS_ANALOGY : C_X_DRIVERS_ANALOGY_DEBUG
	| C_X_DRIVERS_ANALOGY_FAKE
	| C_X_DRIVERS_ANALOGY_LOOP
	| C_X_DRIVERS_ANALOGY_8255
	| C_X_DRIVERS_ANALOGY_PARPORT
	| C_X_DRIVERS_ANALOGY_NI_MITE
	| C_X_DRIVERS_ANALOGY_NI_TIO
	| C_X_DRIVERS_ANALOGY_NI_PCIMIO
	| C_X_DRIVERS_ANALOGY_S526 ;

C_X_DRIVERS_ANALOGY_NI_TIO : C_X_DRIVERS_ANALOGY_NI_MIO ;

C_X_DRIVERS_RTIPC : C_X_DRIVERS_RTIPC_XDDP
	| C_X_DRIVERS_RTIPC_IDDP
	| C_X_DRIVERS_RTIPC_BUFP ;

