Xenomai : Nucleus ;

Nucleus : CONFIG_XENO_OPT_PERVASIVE
	| CONFIG_XENO_OPT_PRIOCPL
	| CONFIG_XENO_OPT_PIPELINE_HEAD
	| CONFIG_PROC_FS
	| CONFIG_SMP
	| CONFIG_XENO_OPT_WATCHDOG
	| CONFIG_MMU
	| CONFIG_XENO_OPT_NUCLEUS
	| CONFIG_XENO_OPT_SELECT
	| CONFIG_XENO_OPT_SYS_STACKPOOLSZ
	| scheduling
	| CONFIG_XENO_OPT_STATS
	| debugging
	| CONFIG_XENO_OPT_SHIRQ
	| Timing
	| Scalability
	| Machine
	| Interfaces
	| Drivers ;

scheduling : CONFIG_XENO_OPT_SCHED_TP
	| CONFIG_XENO_OPT_SCHED_SPORADIC
	| CONFIG_XENO_OPT_SCHED_CLASSES ;

debugging : CONFIG_XENO_OPT_DEBUG_NUCLEUS
	| CONFIG_XENO_OPT_DEBUG_XNLOCK
	| CONFIG_XENO_OPT_DEBUG_QUEUES
	| CONFIG_XENO_OPT_DEBUG_REGISTRY
	| CONFIG_XENO_OPT_DEBUG_TIMERS
	| CONFIG_XENO_OPT_DEBUG_SYNCH_RELAX
	| CONFIG_XENO_OPT_DEBUG_WATCHDOG
	| CONFIG_XENO_OPT_DEBUG ;

Timing : CONFIG_XENO_OPT_TIMING_PERIODIC ;

Scalability : CONFIG_XENO_OPT_SCALABLE_SCHED
	| TimerIndexingMethod ;

TimerIndexingMethod : CONFIG_XENO_OPT_TIMER_LIST
	| CONFIG_XENO_OPT_TIMER_HEAP
	| CONFIG_XENO_OPT_TIMER_WHEEL ;

Machine : CONFIG_XENO_HW_FPU
	| CONFIG_XENO_HW_UNLOCKED_SWITCH
	| NMIWatchdog
	| SMIWorkaround ;

NMIWatchdog : CONFIG_XENO_HW_NMI_DEBUG_LATENCY ;

SMIWorkaround : CONFIG_XENO_HW_SMI_WORKAROUND
	| CONFIG_XENO_HW_SMI_ALL
	| CONFIG_XENO_HW_SMI_INTEL_USB2
	| CONFIG_XENO_HW_SMI_LEGACY_USB2
	| CONFIG_XENO_HW_SMI_PERIODIC
	| CONFIG_XENO_HW_SMI_TCO
	| CONFIG_XENO_HW_SMI_MC
	| CONFIG_XENO_HW_SMI_APMC
	| CONFIG_XENO_HW_SMI_LEGACY_USB
	| CONFIG_XENO_HW_SMI_BIOS ;

Interfaces : nativeSkin
	| posixSkin
	| CONFIG_XENO_SKIN_PSOS
	| CONFIG_XENO_SKIN_UITRON
	| CONFIG_XENO_SKIN_VRTX
	| CONFIG_XENO_SKIN_VXWORKS
	| rtaiSkin
	| CONFIG_XENO_OPT_NOWARN_DEPRECATED
	| rtdmSkin ;

nativeSkin : CONFIG_XENO_SKIN_NATIVE
	| CONFIG_XENO_OPT_NATIVE_PIPE
	| CONFIG_XENO_OPT_NATIVE_SEM
	| CONFIG_XENO_OPT_NATIVE_EVENT
	| CONFIG_XENO_OPT_NATIVE_MUTEX
	| CONFIG_XENO_OPT_NATIVE_COND
	| CONFIG_XENO_OPT_NATIVE_QUEUE
	| CONFIG_XENO_OPT_NATIVE_BUFFER
	| CONFIG_XENO_OPT_NATIVE_HEAP
	| CONFIG_XENO_OPT_NATIVE_ALARM
	| CONFIG_XENO_OPT_NATIVE_MPS
	| CONFIG_XENO_OPT_NATIVE_INTR ;

posixSkin : CONFIG_XENO_SKIN_POSIX
	| CONFIG_XENO_OPT_POSIX_SHM
	| CONFIG_XENO_OPT_POSIX_INTR
	| CONFIG_XENO_OPT_POSIX_SELECT
	| CONFIG_XENO_OPT_DEBUG_POSIX ;

rtaiSkin : CONFIG_XENO_SKIN_RTAI
	| CONFIG_XENO_OPT_RTAI_FIFO
	| CONFIG_XENO_OPT_RTAI_SEM
	| CONFIG_XENO_OPT_RTAI_SHM ;

rtdmSkin : CONFIG_XENO_SKIN_RTDM
	| CONFIG_XENO_OPT_RTDM_SELECT ;

Drivers : SerialDrivers
	| TestingDrivers
	| canDrivers
	| analogyDrivers
	| rtipcDrivers ;

SerialDrivers : drivers16550A ;

drivers16550A : CONFIG_XENO_DRIVERS_16550A
	| CONFIG_XENO_DRIVERS_16550A_PIO
	| CONFIG_XENO_DRIVERS_16550A_MMIO
	| CONFIG_XENO_DRIVERS_16550A_ANY ;

TestingDrivers : benchTime
	| CONFIG_XENO_DRIVERS_IRQBENCH
	| CONFIG_XENO_DRIVERS_SWITCHTEST
	| CONFIG_XENO_DRIVERS_SIGTEST ;

benchTime: CONFIG_XENO_DRIVERS_TIMERBENCH
	| CONFIG_XENO_DRIVERS_KLATENCY ;

canDrivers : CONFIG_XENO_DRIVERS_CAN
	| CONFIG_XENO_DRIVERS_CAN_DEBUG
	| CONFIG_XENO_DRIVERS_CAN_LOOPBACK
	| CONFIG_XENO_DRIVERS_CAN_VIRT
	| canSJA1000Drivers ;

canSJA1000Drivers : CONFIG_XENO_DRIVERS_CAN_SJA1000
	| CONFIG_XENO_DRIVERS_CAN_SJA1000_ISA
	| CONFIG_XENO_DRIVERS_CAN_SJA1000_MEM
	| CONFIG_XENO_DRIVERS_CAN_SJA1000_PEAK_PCI
	| CONFIG_XENO_DRIVERS_CAN_SJA1000_IXXAT_PCI
	| CONFIG_XENO_DRIVERS_CAN_SJA1000_EMS_PCI
	| CONFIG_XENO_DRIVERS_CAN_SJA1000_ESD_PCI
	| CONFIG_XENO_DRIVERS_CAN_SJA1000_PEAK_DNG ;

analogyDrivers : CONFIG_XENO_DRIVERS_ANALOGY
	| CONFIG_XENO_DRIVERS_ANALOGY_DEBUG
	| CONFIG_XENO_DRIVERS_ANALOGY_FAKE
	| CONFIG_XENO_DRIVERS_ANALOGY_LOOP
	| CONFIG_XENO_DRIVERS_ANALOGY_8255
	| CONFIG_XENO_DRIVERS_ANALOGY_PARPORT
	| CONFIG_XENO_DRIVERS_ANALOGY_NI_MITE
	| CONFIG_XENO_DRIVERS_ANALOGY_NI_PCIMIO
	| CONFIG_XENO_DRIVERS_ANALOGY_S526 ;

rtipcDrivers : CONFIG_XENO_DRIVERS_RTIPC
	| CONFIG_XENO_DRIVERS_RTIPCONFIG_XENODDP
	| CONFIG_XENO_DRIVERS_RTIPC_IDDP
	| CONFIG_XENO_DRIVERS_RTIPC_BUFP ;

