%% / Generate a circular distribution created by two exponential functions (similar to Laplace distribution)
% @author Frederik Beuth
%
% - This revision assumes a circular space, hence 1 and X are adjacent values
%\
function Y = symetricalExpCircle(X, mu, a, b, c)

   % Self-demonstration
   if(nargin<1)
      X = 33;
      mu = (X-1)*0.75+1;
      a = 0;
      b = 1;
      c = 0.3;
   end
   
   mu2 = round(mu);
   if(mu2<1)
      error('Mu (%i) is <1!', mu);
   end
   
   if(mu2>X)
      error('Mu (%i) is >X!', mu);
   end
   
   %create one side exp
   Xhalf = (X-1)/2+1;
   x1 = 1:ceil(Xhalf);
   Y1 = a + (b-a) * exp(-c*(x1-1));
   
   % create full function
   Y = zeros(X,1);
   
   % case 1: mu==xHalf => function is precisely aligned in the space
   % case 2: mu<xHalf => right side has to start again
   % case 3: mu>xHalf => left side has to start again   
   if(mu2==Xhalf)
      Y(1:mu2) = Y1(end:-1:1);
      Y(mu2:end) = Y1(1:end);
   
   elseif(mu2<Xhalf)
      xAgain = floor(mu2 + Xhalf);
      Y(1:mu2) = Y1(mu2:-1:1);
      Y(mu2:xAgain-1) = Y1(1:xAgain-mu2);
      Y(xAgain:end) = Y1(end:-1:mu2+1);
      
   elseif(mu2>Xhalf)
      xAgain = floor(mu2 - Xhalf);
      Y(1:xAgain) = Y1(floor(Xhalf)-xAgain+1:floor(Xhalf));
      Y(xAgain+1:mu2) = Y1(mu2-xAgain:-1:1);
      Y(mu2:end) = Y1(1:floor(Xhalf)-xAgain);
   end  
   
   % Self-demonstration
   if(nargin<1)      
      figure
      plot(Y)
      axis([1, X, 0, 1]);
   end
   
end
   
   
   
   
