%% / Generate a distribution created by two exponential functions (similar to Laplace distribution)
% @author Frederik Beuth
%
% Parameters of the exponential equation according to Teichmann2012, eq. 2.4:
% y = a + b * exp(-c*x)
%\
function Y = symetricalExp(X, mu, a, b, c)

   % Self-demonstration
   if(nargin<1)
      X = 33;
      mu = (X-1)*0.25+1;
      a = 0;
      b = 1;
      c = 0.3;
   end

   
   mu2 = round(mu);
   
   %left side
   x1 = 1:mu2;
   Y1 = a + b * exp(-c*(mu2-x1));
   
   %right side
   x2 = mu2+1:X;
   Y2 = a + b * exp(-c*(x2-mu2));
   
   Y = [Y1, Y2];
   
   % Self-demonstration
   if(nargin<1)      
      figure
      plot(Y)
      axis([1, X, 0, 1]);
   end
   
end
   
   
   
   
