%% / Save common parameters for the plots to a file
% @author Frederik Beuth
%\
function saveStandardPlotParams()

   dataDir = 'data/';           % for physiological data
   modelDir = 'results/';         % for model results
   modelDirStd = 'resultsStd/';   % for model results with standard model parameters
   setupDir = 'setups/';
   outputdir = 'img/';
   outputdirStd = 'imgStd/';         % for experiments with standard model parameters
   plotPositions = [0.2, 0.62, 0.75, 0.37; 0.2, 0.18, 0.75, 0.37];
   colors = [ 73 112 169; 100 135 85; 230 200 83; 181 32 68; 217 188 204; 128 128 128]/255;
   markersLine = {'-+', '-o', '-*', '-x', '-d'};
   markers = {'+', 'o', '*', 'x', 'd'};
   labelSize = 18;                   % for label, legend and a)-d)
   noSize = 14;                      % for numbers at the axis
   sizeFig = [0.5, 0.5, 7.5, 15];    % PNG figure size in cm 

   filename = sprintf('%s/plotParams.mat', setupDir);
   save(filename, 'dataDir', 'modelDir', 'modelDirStd', 'setupDir', 'plotPositions', 'colors', 'markersLine', 'markers', ...
      'labelSize', 'noSize', 'sizeFig', 'outputdir', 'outputdirStd');
   fprintf('Ready\n');
   
end
