%% / Maximum operation via a non-linear summation
% @author Frederik Beuth
%
% - For vectors, Y = maxNonLin(X) returns a sum of mostly only the largest element in X.
% - Algorithm: Y = sum( (sum(X.^4)).^0.25)
%
% - For matrices,
%   maxNonLin(X) is a row vector containing the maximum element from each
%   column. For N-D arrays, maxNonLin(X) operates along the first
%   non-singleton dimension.
%
% - Y = maxNonLin(X,Y) returns an array the same size as X and Y with the
%   largest elements taken from X or Y. Either one can be a scalar.
%
% - Y = maxNonLin(X,[ ],DIM) operates along the dimension DIM. 
%\
function Y = maxNonLin(this,A,B,dim)
   
   % Non-linearity parameter
   P1 = this.poolingP1;
   P2 = 1/this.poolingP1;   
   v = this.poolingP1 / 4;
   
   if(nargin==2)
      B = [];
      dim = ndims(A);
   end
   
   % maxNonLin over a particular dimension
   if(nargin==4)
         
      if(~isempty(B))
         error('Providing 3 parameters which is not allowed. If "dim" is provided, second parameter must be empty.');
      end   
      
      % Sum function with strong non-linearities
      Y1 = sum(A.^P1, dim);
      Y = Y1.^P2;
      
   % maxNonLin over two arrays
   else
      catDim = ndims(A)+1;
      C = cat(catDim, A, B);
      
      % Sum function with strong non-linearities
      if(1)
         Y1 = sum(C.^P1, catDim);
         Y = Y1.^P2;
         
      % Test of softmax activation function from matlab, not working well for this purpose
      else         
         Y1 = exp(A) ./ sum(exp(C),catDim);
         Y2 = exp(B) ./ sum(exp(C),catDim);
         C3 = cat(catDim, Y1, Y2);
         %Y = max(C3, [], catDim);
         Y = sum(C3, [], catDim);
      end
   end
   
   Y = Y * v;
      
end 
