%% / Calculate 1D Gaussian kernel
% @author Frederik Beuth
%
% - Maximum is 1
%
%\
%> @param kernelsize Size of the envelope
%> @param mu Center of the Gauss. Valid values are in the range 1:kernelsize 
%> @param sigma Standard deviation
function K = gauss1D(kernelsize, mu, sigma)

   X = 1:kernelsize;      
   
   % Version which uses the equation directly instead of normpdf.m . 
   % This avoids usage of the statistics toolbox.
   % Equation: f(x)=exp(- (x-mu)^2 / (2*sigma^2) )
   K = exp( -0.5*( (X-mu)/(sigma) ).^2);   
   
end