%% > Function to format the plot nicely
%> @author Frederik Beuth
function formatPlotB(outDir, noSize, L, type, figNo)

   ylim([0,1.05]);
   xlim([1,L]);
   set(gca, 'YTick', [0,1]);
   set(gca, 'XTick', [1:(L-1)/4:L]);  
   box off
   set(gca, 'linewidth', 2, 'fontsize', noSize); 
   
   switch(type)
   case 1
      filename = sprintf('%s/fig%i_layer4_1.png', outDir, figNo);
   case 2
      filename = sprintf('%s/fig%i_layer4_2.png', outDir, figNo);
   case 3
      filename = sprintf('%s/fig%i_layer2.png', outDir, figNo);
   end
   print(filename, '-dpng', '-r225');
end
