%% / Generate a custom 2D gaussian 
% @authors Thomas Dideriksen; adapted by Frederik Beuth
% 
% <a href="http://www.mathworks.com/matlabcentral/fileexchange/9556-custom-2d-gauss">File</a> at Matlab-Central from Thomas Dideriksen
%\
%
%  gauss = customgauss(gsize, sigmax, sigmay, theta, offset, factor, center)
%
%> @param          gsize     Size of the output 'gauss', should be a 1x2 vector
%> @param          sigmax    Std. dev. in the X direction
%> @param          sigmay    Std. dev. in the Y direction
%> @param          theta     Rotation in degrees
%> @param          offset    Minimum value in output
%> @param          factor    Related to maximum value of output, should be 
%>                           different from zero
%> @param          center    The center position of the gaussian, should be a
function ret = customgauss(gsize, sigmax, sigmay, theta, offset, factor, center)
ret     = zeros(gsize);
rbegin  = -(gsize(1) / 2 + 0.5);
cbegin  = -(gsize(2) / 2 + 0.5);
for r=1:gsize(1)
    for c=1:gsize(2)
        ret(r,c) = rotgauss(rbegin+r,cbegin+c, theta, sigmax, sigmay, offset, factor, center);
    end
end


function val = rotgauss(x, y, theta, sigmax, sigmay, offset, factor, center)
xc      = center(1);
yc      = center(2);
theta   = (theta/180)*pi;
xm      = (x-xc)*cos(theta) - (y-yc)*sin(theta);
ym      = (x-xc)*sin(theta) + (y-yc)*cos(theta);
u       = (xm/sigmax)^2 + (ym/sigmay)^2;
val     = offset + factor*exp(-u/2);
