% Demonstrate hyperdimensional encoding implementation of the SeqSLAM core
%
% HDC tutorial KI19
%
% Peer Neubert 
% peer.neubert@etit.tu-chemnitz.de
%
function demo_hvSeqSLAM    

    % load data
    W = load('winter.mat','D');
    S = load('summer.mat','D');    
    GT = eye(288);

    % initilize random number generator for repeatability
    rng(0);
    
    % prepare visualization
    h = [];
    names = {};
    figure();
    
    % run different sequence length parameters
    for d = 0
        
        % create VSA instance
    
        % create random position hypervectors
        % the same positions have to be used for all encodings!
    
        % encode
                        
        % evaluate
        DD = pdist2(S.D, W.D,'cosine');
    
        % visualization
        [P,R] = createPR(DD, GT); 
        hold all;
        h(end+1) = plot(R,P);
        names{end+1} = sprintf('d=%d', d);
        legend(h,names);
        xlabel('Recall');
        ylabel('Precision');
        drawnow
    end
end

% Hyperdimensional encoding of image desciptor sequences
%
% vsa ... vsa class instance with .bundle() and .bind() operators
% pos ... [2*ds+1,m] matrix, each row is position vector
% X ... [n,m] matrix, each row is place descriptor of length m
% d ... sequence length parameter, sequence length is 2*ds+1
%
% Y ... [n,m] matrix, each row is HD vecor encoding a sequence of lengh (2*ds+1)
function Y = createSeqBundle(vsa,pos,X,d)
    
end

    