% DD ... distance matrix
% GThard ... ground truth matching matrix: places that MUST be matched
function [P, R] = createPR(DD, GThard)

    GT = logical(GThard); % ensure logical-datatype
    
    % init precision and recall vectors
    R = 0;
    P = 1;
    
    % select start and end treshold
    startV = min(DD(:)); % start-value for treshold
    endV = max(DD(:)); % end-value for treshold
    
    % iterate over different thresholds
    for i=linspace(startV, endV, 100) 
        B = DD<=i; % apply threshold
        
        TP = nnz( GT & B ); % true positives
        FN = nnz( GT & (~B) ); % false negatives
        FP = nnz( (~GT) & B ); % false positives
        
        P(end+1) = TP/(TP + FP); % precision
        R(end+1) = TP/(TP + FN); % recall
    end
end
