classdef VSA_bipolar < handle 
    %VSA_BIPOLAR class
    properties
        nDims % number of dimensions
    end
        
        
    methods
        function obj = VSA_bipolar(nDims)
            obj.nDims = nDims;
        end
        
        % random vector generation
        function vector = generate(obj,n)
            % generate n random vectors with 'nDim' number of dimensions
            vector = rand([n, obj.nDims])*2-1;
        end
        
        % bundling
        function bundled_vectors = bundle(obj,input_vectors)
            % element-wise addition 
            bundled_vectors = sum(input_vectors);
            % cut the result at -1 and 1
            bundled_vectors(bundled_vectors>1)=1;
            bundled_vectors(bundled_vectors<-1)=-1;
        end
        
        % binding 
        function bound_vector = bind(obj,v1,v2)
            % element-wise multiplication
            bound_vector = v1.*v2;
        end
        
        % unbinding
        function unbound_vector = unbind(obj,v1,v2)
            % element-wise multiplication
            unbound_vector = v1.*v2;
        end
        
        % similarity measurement
        function similarity = sim(obj, v1, v2)
            % compute the cosine similarity between two input vectors
            similarity = dot(v1,v2);
            similarity = similarity/(norm(v1)*norm(v2));
        end
    end
end

