% Demonstrates HDC-DELF encoding on a GardensPointWalking sequence (takes
% about 10 seconds)
%
function demo()
    basepath = '.';

    % load Gardenspoint data    
    L1 = load(fullfile(basepath, 'data/GardensPointWalking/day_left/delf.mat'), 'Y');
    L2 = load(fullfile(basepath, 'data/GardensPointWalking/night_right/delf.mat'), 'Y');
    
    % setup parameters 
    params.nDims=4096;
    params.nFeat=200; 
    params.nX=4; 
    params.nY=6; 

    % create holistic descriptors D1 and D2 using HDC
    t1 = tic; D1 = encodeImagesHDC(L1.Y, params); t1=toc(t1);
    fprintf('encoding dataset 1 took %d seconds\n', t1); 
    
    t2 = tic; D2 = encodeImagesHDC(L2.Y, params); t2=toc(t2);
    fprintf('encoding dataset 2 took %d seconds\n', t2);

    % standardize and compare
    t3 = tic;
    mu1 = mean(D1);
    DD = pdist2(D1-mu1, D2-mu1, 'cosine'); 
    t3 = toc(t3);
    fprintf('comparing the HDC descriptors took %d seconds\n', t3);
    
    % load ground truth
    load(fullfile(basepath, 'data/gt.mat'), 'GT');

    % evaluate
    [P,R] = createPR(-DD, GT.GThard, GT.GTsoft);
    AUC = trapz(R,P)
    
    fprintf('The above number is the result for GPW DL-NR from the CVPR paper and should be 0.47\n');
    
    
end


