% Run the inconsistency resolution procedure from the paper.
%
% For details see inconsistencyResolutionProcedure.m
%
% DD ... pairwise descriptor distances, each row is a database element,
%        each column is a query set element
% DD_DB ... database descriptor distances (can be empty if generalFlag==0)
% DD_Q ... query descriptor distances
% generalFlag ... toggle between IRP(=0) and gIRP(=1) (default 0)
% preemptRate ... preemption rate (parameter of IRP) (default 1)
%
% M ... output distance matrix
%
%
%   =====================================================================
%   Copyright (C) 2021  Peer Neubert, peer.neubert@etit.tu-chemnitz.de
%   
%   This program is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%   
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%   
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
%   =====================================================================
% 
function M = run_IRP(DD, DD_Q, DD_DB, generalFlag, preempt_rate)
    if ~exist('generalFlag', 'var'), generalFlag = 0; end
    if ~exist('preempt_rate', 'var'), preempt_rate = 1; end
    
    if ~generalFlag
        % IRP
        M1 = inconsistencyResolutionProcedure(DD', DD_Q, preempt_rate);
        M = M1';
    else
        % gIRP
        AM1 = inconsistencyResolutionProcedure(DD', DD_Q, preempt_rate);
        AM = inconsistencyResolutionProcedure(AM1', DD_DB, preempt_rate);

        BM1 = inconsistencyResolutionProcedure(DD, DD_DB, preempt_rate);
        BM2 = inconsistencyResolutionProcedure(BM1', DD_Q, preempt_rate);
        
        BM = BM2';        
        M = max(AM,BM);                
        
    end
end

