% Demo that recreates the results from Table I for Gardens Point Walking
% day_left vs. night_right using NetVALD descriptors in a General Place 
% Recognition setup (first row).
%
%
%   =====================================================================
%   Copyright (C) 2021  Peer Neubert, peer.neubert@etit.tu-chemnitz.de
%   
%   This program is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%   
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%   
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
%   =====================================================================
% 
function demo

    addpath misc

    % load GardensPointWalking day-left vs night-right NetVLAD data
    % DD ... pairwise similarities, each row corresponds to a NetVLAD
    %        descriptor from day-left, each column to one from night-right    
    % DD_Q ... pairwise similarities from Query NetVLAD descriptors (night-right)
    % DD_DB ... pairwise similarities from DB NetVLAD descriptors (day-left)
    % GT ... ground truth matchings 
    fprintf('Loading NetVLAD distance matrices for GardensPointWalking DL-NR\n');
    load('misc/data.mat', 'DD', 'DD_Q', 'DD_DB', 'GT');
    
    % no IRP
    fprintf('- without IRP (should be ~0.40):\n');
    [P,R] = createPR(-DD, GT.GThard, GT.GTsoft); 
    AUC = trapz(R,P)
    
    % IRP
    fprintf('- using IRP (should be ~0.44):\n');
    generalIRP_flag = 0;
    DD_IRP = run_IRP(DD, DD_Q, [], generalIRP_flag, 1);
    [P,R] = createPR(-DD_IRP, GT.GThard, GT.GTsoft); 
    AUC = trapz(R,P)
    
    
    % gIRP
    fprintf('- using gIRP (should be ~0.48):\n');
    generalIRP_flag =1;
    DD_gIRP = run_IRP(DD, DD_Q, DD_DB, generalIRP_flag, 1);
    [P,R] = createPR(-DD_gIRP, GT.GThard, GT.GTsoft); 
    AUC = trapz(R,P)