% Demo that recreates the results with ICM_mul, ICM_min and SeqConv from 
% Table II and Table III for StLucia 100909_0845 vs 190809_0845 using 
% NetVLAD descriptors
%
%
%   =====================================================================
%   Copyright (C) 2021  Stefan Schubert, stefan.schubert@etit.tu-chemnitz.de
%   
%   This program is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%   
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%   
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
%   =====================================================================
% 
function demo

  %% load data
  data = load('+misc/data_stlucia_100909_0845vs190809_0845.mat');
  
  %% run ICM_mul (with multiplicative cost function)
  S_icm_mul_db = run_ICM(data.S, data.S_DB, data.S_Q, 'DB', 'mul');
  S_icm_mul_db_q = run_ICM(data.S, data.S_DB, data.S_Q, 'DB-Q', 'mul');
  S_icm_mul_db_q_seq = run_ICM(data.S, data.S_DB, data.S_Q, 'DB-Q-Seq', 'mul');
  
  %% run ICM_min (with minimum-based cost function)
  S_icm_min_db = run_ICM(data.S, data.S_DB, data.S_Q, 'DB', 'min');
  S_icm_min_db_q = run_ICM(data.S, data.S_DB, data.S_Q, 'DB-Q', 'min');
  S_icm_min_db_q_seq = run_ICM(data.S, data.S_DB, data.S_Q, 'DB-Q-Seq', 'min');
  
  %% run SeqConv
  S_SeqConv = SeqConv(data.S, 11);
  
  %% eval results with area under curve (AUC)
  disp('Area under curve (AUC) for StLucia 100909_0845 vs 190809_0845:');
  
  % raw netvlad descriptr
  [P,R] = misc.createPR(data.S, data.GThard, data.GTsoft);
  disp(['Raw: AUC=', num2str(round(trapz(R,P),2))]);
  
  % Info: DB
  [P,R] = misc.createPR(S_icm_mul_db, data.GThard, data.GTsoft);
  disp(['ICM_mul (DB): AUC=', num2str(round(trapz(R,P),2))]);
  
  [P,R] = misc.createPR(S_icm_min_db, data.GThard, data.GTsoft);
  disp(['ICM_min (DB): AUC=', num2str(round(trapz(R,P),2))]);
    
  % Info: DB+Q
  [P,R] = misc.createPR(S_icm_mul_db_q, data.GThard, data.GTsoft);
  disp(['ICM_mul (DB+Q): AUC=', num2str(round(trapz(R,P),2))]);
  
  [P,R] = misc.createPR(S_icm_min_db_q, data.GThard, data.GTsoft);
  disp(['ICM_min (DB+Q): AUC=', num2str(round(trapz(R,P),2))]);
  
  % Info: DB+Q+Seq
  [P,R] = misc.createPR(S_icm_mul_db_q_seq, data.GThard, data.GTsoft);
  disp(['ICM_mul (DB+Q+Seq): AUC=', num2str(round(trapz(R,P),2))]);

  [P,R] = misc.createPR(S_icm_min_db_q_seq, data.GThard, data.GTsoft);
  disp(['ICM_min (DB+Q+Seq): AUC=', num2str(round(trapz(R,P),2))]);
  
  % SeqConv
  [P,R] = misc.createPR(S_SeqConv, data.GThard, data.GTsoft);
  disp(['SeqConv (Seq): AUC=', num2str(round(trapz(R,P),2))]);
  