% Demo that recreates the results from Table I (Multi-Matching Performance) 
% for CMU 20110421 vs 20100915 using NetVLAD descriptors
%
%
%   =====================================================================
%   Copyright (C) 2021  Stefan Schubert, stefan.schubert@etit.tu-chemnitz.de
%   
%   This program is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%   
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%   
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
%   =====================================================================
% 
function demo
  addpath('misc/');

  %% load data
  data = load('misc/data_cmu_20110421vs20100915.mat');

  %% run EPR with periodic and event-based relocalization
  S_epr_pr = run_epr(data.S, data.S_DB, 'periodic');
  S_epr_er = run_epr(data.S, data.S_DB, 'event');
  
  %% show obtained similarity matrices
  figure;
  subplot(2,2,1); imshow(~data.GThard); title('Ground truth');
  subplot(2,2,2); imshow(-data.S,[]); colormap('hot'); title('full');
  subplot(2,2,3); imshow(-S_epr_pr,[]); colormap('hot'); title('EPR-PR');
  subplot(2,2,4); imshow(-S_epr_er,[]); colormap('hot'); title('EPR-ER');

  %% eval results with area under curve (AUC)
  disp('Results for CMU 20110421-vs-20100915:');
  
  [P,R] = createPR(data.S, data.GThard, data.GTsoft);
  disp(['full: AUC=', num2str(round(trapz(R,P),2))]);
  
  [P,R] = createPR(S_epr_pr, data.GThard, data.GTsoft);
  disp(['EPR-PR: AUC=', num2str(round(trapz(R,P),2))]);
   
  [P,R] = createPR(S_epr_er, data.GThard, data.GTsoft);
  disp(['EPR-ER: AUC=', num2str(round(trapz(R,P),2))]);


