function Y = munu_s(tr,X,i)
%
%  Solves shifted linear systems with the real matrix A or its 
%  transposed A':
%
%  for tr = 'N':
%
%    Y = inv(A+p(i)*I)*X;
%
%  for tr = 'T':
%
%    Y = inv(A.'+p(i)*I)*X.
%
%  A+p(i)*I is given implicitely in a factored form. The factores are
%  provided as global data. These data must be generated by calling
%  'munu_m_i' AND 'munu_s_i' before calling this routine!
%  
%  Calling sequence:
%
%    Y = munu_s(tr,X,i)
%
%  Input:
%
%    tr        (= 'N' or 'T') determines whether shifted systems with 
%              A or A' should be solved;
%    X         a matrix of proper size;
%    i         the index of the shift parameter.
%
%  Output:
%
%    Y         the resulting solution matrix.
%  
%
%   LYAPACK 1.0 (Thilo Penzl, September 1999)

if nargin~=3
  error('Wrong number of input arguments.');
end

global LP_ML LP_MU 

if ~length(LP_ML) | ~length(LP_MU)
  error('This routine needs global data which must be generated by calling ''munu_m_i'' first.');
end 

eval(lp_e( 'global LP_L',i,' LP_U',i ));

is_init1 = eval(lp_e( 'length(LP_L',i,')' ));
is_init2 = eval(lp_e( 'length(LP_U',i,')' ));
if ~is_init1 | ~is_init2
  error('This routine needs global data which must be generated by calling ''munu_s_i'' first.');
end 


if tr=='N'
  eval(lp_e( 'Y = LP_MU*(LP_U',i,'\(LP_L',i,'\(LP_ML*X)));' ));     
elseif tr=='T'
  eval(lp_e( 'Y = LP_ML''*(LP_L',i,'.''\(LP_U',i,'.''\(LP_MU''*X)));' ));     
else
  error('tp must be either ''N'' or ''T''.');
end



