function [ZB,ZC] = munu_pst(ZB,ZC,ML,MU,iprm)
%
%  Postprocessing. This routine is the counterpart of preprocessing
%  routine 'munu_pre'. It backtransforms the low rank Cholesky factors
%  ZB or ZC (or quantities (n-by-? matrices) related to these matrices):
%
%    ZB <-- inv(P) * inv(MU) * ZB
%
%    ZC <-- inv(P) * inv(ML') * ZC
%
%  where inv(P) is the inverse permutation described by iprm. The resulting
%  matrices ZB and ZC are the (approximate) low rank Cholesky factors of
%  the original generalized Lyapuonov equations related to the 
%  generalized system (1) in the prolog of 'munu_pre'.
%
%  Calling sequence:
%
%    [ZB,ZC] = munu_pst(ZB,ZC,ML,MU,iprm)
%
%  Input:
%
%    ZB        matrix containing n rows, e.g., low rank Cholesky factor
%              ZB of controllability Gramian.
%              set [], if only ZC should be backtransformed; 
%    ZC        matrix containing n rows, e.g., low rank Cholesky factor
%              ZC of observability Gramian;
%              set [], if only ZB should be backtransformed. 
%    ML        left LU factor of (reordered) system matrix M;
%              if ML is available as global data (i.e., if 'munu_m_i'
%              has been called before calling this routine, but not
%              'munu_d_i'), ML needs not be provided as parameter: 
%              set ML = []. Also it needs not be provided if ZC=[];
%    MU        right LU factor of (reordered) system matrix M;
%              if MU is available as global data (i.e., if 'munu_m_i'
%              has been called before calling this routine, but not
%              'munu_d_i'), MU needs not be provided as parameter: 
%              set MU = []; Also it needs not be provided if ZB=[];
%    iprm      the inverse permutation generated by 'munu_pre'.
%
%  Output:
%
%    ZB         backtransformed input matrix ZB;
%               [] is returned if ZB = [] on entry;
%    ZC         backtransformed input matrix ZC;
%               [] is returned if ZC = [] on entry.
%
%
%  LYAPACK 1.0 (Thilo Penzl, October 1999)

% Input data not completely checked!

if length(ZB) 
  if length(MU)
    ZB = MU\ZB;
    ZB = ZB(iprm,:);
  else
    global LP_MU
    if ~length(LP_MU)
      error('If MU is not provided via the command line, this routine needs global data which must be generated by calling ''munu_m_i'' first. Note: this data might have been destroyed by ''munu_m_d''.');
    end
    ZB = LP_MU\ZB;
    ZB = ZB(iprm,:);
  end  
else
  ZB = [];
end

if length(ZC) 
  if length(ML)
    ZC = ML'\ZC;
    ZC = ZC(iprm,:);
  else
    global LP_ML
    if ~length(LP_ML)
      error('If ML is not provided via the command line, this routine needs global data which must be generated by calling ''munu_m_i'' first. Note: this data might have been destroyed by ''munu_m_d''.');
    end
    ZC = LP_ML'\ZC;
    ZC = ZC(iprm,:);
  end  
else
  ZC = [];
end

