function msns_s_i(p)
%
%  Generates the data used in 'msns_s'. Data are stored in global
%  variables.
%
%  NOTE that 'msns_m_i' must be called before calling this routine.
% 
%  Calling sequence:
%
%    msns_s_i(p)
%
%  Input:
%
%    p         vector containing the ADI shift parameters p(i).
%
%  Remarks:
% 
%    The matrices M and N, which have been provided as global data by 
%    'msns_m_i', must be symmetric, negative definite. M must be 
%    symmetric, positive definite.
%
%    The entries of p must be real and negative.
%
%
%  LYAPACK 1.0 (Thilo Penzl, May 1999)

if nargin~=1
  error('Wrong number of input arguments.');
end

if any(imag(p))
  error('p must be real (Note that this is the symmetric case)!');
end

if any(p>=0)
  error('Entries of p must be negative!');
end

l = length(p);

global LP_N LP_M

if ~length(LP_M) | ~length(LP_N)
  error('This routine needs global data which must be generated by calling ''msns_m_i'' first.');
end 

for i = 1:l

  eval(lp_e( 'global LP_U',i ));

  eval(lp_e( 'LP_U',i,' = chol(-LP_N-p(',i,')*LP_M);' ));    % Note the minus!

end

