function msns_m_i(M,MU,N)
%
%  Generates of the data used in 'msns_m'. Data are stored in global
%  variables.
%
%  MU is generated by the routine 'msns_pre'
%
%  Calling sequence:
%
%    msns_m_i(M,MU,N)
%
%  Input:
%
%    M         real, symmetric matrix M
%    MU        real Cholesky factor of M,
%    N         real, symmetric matrix N.
%
%  After calling this routine MU can be deleted to save memory.
%
% 
%  LYAPACK 1.0 (Thilo Penzl, May 1999)

if nargin~=3
  error('Wrong number of input arguments.');
end

if norm(M-M','fro')~=0
  error('M is not symmetric!');
end

if norm(N-N','fro')~=0
  error('N is not symmetric!');
end

global LP_M LP_MU LP_N

LP_MU = MU;
LP_M = M;
LP_N = N;






