function Y = msns_m(tr,X)
%
%  Evaluates matrix-matrix products with the symmetric matrix A, 
%  i.e., Y = A*X.
%
%  A is given implicitely as A = inv(MU')*N*inv(MU). MU and N are
%  provided as global data. These data must be generated by calling
%  'msns_m_i' before calling this routine!
%  
%  If called without input parameters, this routine returns the order of
%  the matrix A.
%
%  Calling sequence:
%
%    Y = msns_m(tr,X)
%    n = msns_m
%
%  Input:
%
%    tr        is not referenced;
%    X         a matrix of proper size.
%
%  Output:
%
%    Y         the resulting product;
%    n         the order of the matrix A.
%
%
%  LYAPACK 1.0 (Thilo Penzl, May 1999)

ni = nargin;

if ni~=2 & ni~=0
  error('Wrong number of input arguments.');
end

global LP_MU LP_N

if ~length(LP_MU) | ~length(LP_N)
  error('This routine needs global data which must be generated by calling ''msns_m_i'' first.');
end 

if ni==0
  Y = size(LP_N,1);  
else
  Y = LP_MU'\(LP_N*(LP_MU\X));
end


