function X = au_pst(X,iprm)
%
%  Postprocessing. This routine is the counterpart of 'au_pre'. It 
%  re-reorderes data generated by LYAPACK routines after the 
%  preprocessing:  X <-- X(:,iprm).
%
%  Calling sequence:
%
%    X = au_pst(X,iprm)
%
%  Input:
%
%    X         n-x-m matrix; 
%    iprm      the inverse permutation generated by 'au_pre'.
%
%  Output:
%
%    X         re-permuted matrix.
%
%  Example:
%
%    After preprocessing with 'au_pre' the Lyapunov equation 
%    A*Q + Q*A = - B*B' has been solved by 'lp_lrsl', which has delivered
%    a low rank approximation Q~Z*Z'. If the solution of the original
%    Lyapunov equation (i.e., the equation before preprocessing) is sought,
%    Z must be re-reordered by calling
%
%      Z = au_pst(Z,iprm);
%  
%
%  LYAPACK 1.0 (Thilo Penzl, May 1999)

% Input data not completely checked!
 
X = X(iprm,:);
